<%@ Page Title="Registrants" EnableEventValidation="false" Language="C#" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="VIRP_WEB.Custom.BPR.Registrants.NameUpdateSearchRegistrant" Codebehind="NameUpdateSearchRegistrant.aspx.cs" %>
<%@ Register src="~/Controls/Custom/BPR/BaseControlTextBox.ascx" tagname="BaseControlTextBox" tagprefix="UserControl" %>
<%@ Register src="~/Controls/Custom/BPR/UserControlDate.ascx" tagname="UserControlBirthDate" tagprefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Non-Verified Names > Registrant Search"/>
    </div>    
    <asp:Panel ID="PanelSearchCriteria" runat="server" GroupingText="Registrant Search Criteria">
    <table>
        <tr>
            <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxLastName" runat="server" /></td>
            <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
            <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxLast4SSN" runat="server" /></td>
            <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
            <td><UserControl:UserControlBirthDate ID="UserControlBirthDate" runat="server" />
            </td>
             <td>
                <br />
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Button ID="Search" runat="server" onclick="Search_Click" Text="&nbsp;Search&nbsp;" ValidationGroup="SearchRegistrant" />
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Button runat="server" ID="ButtonClear" Text="&nbsp;&nbsp;Clear&nbsp;&nbsp;" OnClick="ButtonClear_Click"/>
            </td>
       </tr>
    </table>
    <asp:CustomValidator ID="CustomValidatorSearchCriteria" runat="server" ErrorMessage="Please enter at least one of the following fields: Last Name, Last 4 of SSN, or Date of Birth."
    ValidationGroup="SearchRegistrant" ForeColor="Red"></asp:CustomValidator>
   <br />
 
    </asp:Panel>
    <asp:Panel ID="PanelRegistrantsList" runat="server"  Width="65%">
        <asp:Label runat="server" ID="LabelNumberOfRegistrantsFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right; width: 65%;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="false" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="false" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
            </div>
            <asp:GridView 
                ID="GridViewRegistrant" 
                Width="65%"
                runat="server" 
                OnRowCommand = "GridViewRegistrant_RowCommand"
                AutoGenerateColumns="False" 
                DataSourceID="RegistrantSearchDS"
                AllowPaging="True" 
                AllowSorting="True" 
                Visible="False" 
                Caption="To sort please click table headings" 
                EnableModelValidation="True"
                DataKeyNames="REGISTRANT_ID"
                PagerSettings-Mode="Numeric"
                onrowdatabound="GridViewRegistrant_RowDataBound"
                OnPageIndexChanging="gridView_PageIndexChanging">
            <EmptyDataTemplate>No match found. Please verify the information you entered in the search criteria.</EmptyDataTemplate>
            <Columns>
                <asp:TemplateField HeaderText="ID"  AccessibleHeaderText="ID" >
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelRegistrantId" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("REGISTRANT_ID")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Registrant Name" >
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID="LabelRegistrantLastName" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Name"))  %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                 <asp:TemplateField HeaderText="Last 4 of SSN">
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID="LabelLast4Ssn" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Last4Ssn"))  %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="Date of Birth" >
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID="LabelDateOfBirth" SkinID="DataLabel" runat="server" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Dob"))  %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

               <asp:TemplateField HeaderText="EDIPI" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelServiceStatus" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("EDIPI")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
               
                <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" ValidationGroup="SearchRegistrant"
                   ItemStyle-VerticalAlign="Middle" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText = "Select" HeaderText ="Action" />
            </Columns>
        </asp:GridView>
        <asp:ObjectDataSource 
        ID="RegistrantSearchDS" runat="server" 
            SelectMethod="SearchRegistrantsForNameUpdate" 
            SelectCountMethod="SearchRegistrantsForNameUpdateCount"
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True"  
            TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager"
            onselected="RegistrantSearchDS_Selected">
        <SelectParameters>
            <asp:ControlParameter ControlID="BaseControlTextBoxLastName" Name="lastName" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="BaseControlTextBoxLast4SSN" Name="last4SSN" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="UserControlBirthDate" Name="dob" PropertyName="Text" Type="String" />
            <asp:Parameter Name="sort" Type="String" />
            <asp:Parameter Name="startRow" Type="Int32" />
            <asp:Parameter Name="maxRows" Type="Int32" />
            <asp:Parameter Name="totalRecords" Type="Int32" Direction="Output" />
       </SelectParameters>
    </asp:ObjectDataSource>
     </asp:Panel>


</asp:Content>

